﻿SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

-- =============================================
-- New Historic.HisCaseResult field 
-- RHL - November 2013 - US2178
-- =============================================
IF NOT EXISTS(SELECT * FROM sys.columns WHERE Name = N'HisCaseResult' AND object_id = OBJECT_ID(N'Historic'))
BEGIN
	ALTER TABLE Historic ADD HisCaseResult [varchar](2)
END

-- =============================================
-- Then we gotta update correspondent stored procedures Sp_updaterespondenthistory and VX_sp_GetHistoric
-- Sp_updaterespondenthistory now uses MERGE for SQL 2008 and above
-- RHL - November 2013 - US2178
-- =============================================
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Sp_updaterespondenthistory]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[Sp_updaterespondenthistory]
GO

DECLARE @version varchar(128), @majorversion int
SET @version = CAST(SERVERPROPERTY('productversion') as varchar(128))
SET @majorversion = SUBSTRING(@version,1,CHARINDEX('.',@version,0)-1)
IF @majorversion >= 10 AND NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Sp_updaterespondenthistory]') AND type in (N'P', N'PC'))
	BEGIN
		--MERGE is only supported on SQL2008 and above
		EXEC dbo.sp_executesql @statement = N'
		CREATE PROCEDURE [dbo].[Sp_updaterespondenthistory]
			@ProjectId           INT,
			@CollectMode         INT,
			@HisRespondent       VARCHAR(10),
			@HisCallNumber       INT,
			@HisInterviewer      VARCHAR(10),
			@HisResult           VARCHAR(2),
			@HisCallDate         DATETIME,
			@HisTimeSlot         INT,
			@HisCallDuration     INT,
			@HisDataType         INT,
			@HisStartQuestion    VARCHAR(10),
			@HisEndQuestion      VARCHAR(10),
			@HisMonitoring       BIT,
			@HisDialerLine       INT,
			@HisWait             INT,
			@HisPause            INT,
			@HisFileReference    VARCHAR(120),
			@HisPreviousCallDate DATETIME,
			@HisLifeState        VARCHAR(2),
			@HisPhone            VARCHAR(20) = NULL,
			@DialingMode         INT = NULL, -- Null => Do not change
			@LevelChanged        BIT = 0,
			@Notes               NVARCHAR(MAX) = NULL,
			@RuleId              INT = NULL,
			@ExtRuleId           INT = NULL,
			@NextCBKDate         DATETIME = NULL,
			@IsImported          BIT = 0,
			@HisCaseResult		 VARCHAR(2) = NULL
		AS
		
		MERGE Historic as target
		USING (SELECT @HisRespondent, @HisCallNumber, --PK
				 @HisInterviewer, @HisResult, @HisCallDate, @HisTimeSlot, @HisCallDuration, @HisDataType, @HisStartQuestion, @HisEndQuestion,
				 @HisMonitoring, @HisDialerLine, @HisWait, @HisPause, @HisFileReference, @HisPreviousCallDate, @HisLifeState, @projectId,
				 @collectMode, @HisPhone,@DialingMode, @LevelChanged, @Notes, @RuleId, @ExtRuleId, @NextCBKDate,
				 @IsImported, @HisCaseResult) 
				 AS source (hisrespondent, hiscallnumber, hisinterviewer, hisresult, hiscalldate, histimeslot, hiscallduration,
				 hisdatatype, hisstartquestion, hisendquestion, hismonitoring, hisdialerline, hiswait, hispause, hisfilereference,
				 hispreviouscalldate, hislifestate, projectid, collectmode, HisPhone, DialingMode, LevelChanged, Notes,
				 RuleId, ExtRuleId, NextCallBack, IsImported, HisCaseResult)
		ON (target.HisRespondent = source.HisRespondent
			AND target.HisCallNumber = source.HisCallNumber)
		WHEN MATCHED THEN
			UPDATE SET  hisrespondent = source.HisRespondent,
				 hiscallnumber = source.HisCallNumber,
				 hisinterviewer = source.HisInterviewer,
				 hisresult = source.HisResult,
				 hiscalldate = source.HisCallDate,
				 histimeslot = source.HisTimeSlot,
				 hiscallduration = source.HisCallDuration,
				 hisdatatype = source.HisDataType,
				 hisstartquestion = source.HisStartQuestion,
				 hisendquestion = source.HisEndQuestion,
				 hismonitoring = source.HisMonitoring,
				 hisdialerline = source.HisDialerLine,
				 hiswait = source.HisWait,
				 hispause = source.HisPause,
				 hisfilereference = source.HisFileReference,
				 hispreviouscalldate = source.HisPreviousCallDate,
				 hislifestate = source.HisLifeState,
				 projectid = source.projectId,
				 collectmode = source.collectMode,
				 HisPhone = source.HisPhone,
				 DialingMode = IsNull(source.DialingMode, target.DialingMode),
				 LevelChanged = source.LevelChanged,
				 Notes = source.Notes,
				 RuleId = source.RuleId,
				 ExtRuleId = source.ExtRuleId,
				 NextCallBack = source.NextCallBack,
				 IsImported = source.IsImported,
				 HisCaseResult = source.HisCaseResult
		WHEN NOT MATCHED THEN
			INSERT (hisrespondent,
						  hiscallnumber,
						  hisinterviewer,
						  hisresult,
						  hiscalldate,
						  histimeslot,
						  hiscallduration,
						  hisdatatype,
						  hisstartquestion,
						  hisendquestion,
						  hismonitoring,
						  hisdialerline,
						  hiswait,
						  hispause,
						  hisfilereference,
						  hispreviouscalldate,
						  hislifestate,
						  projectid,
						  collectmode,
						  HisPhone,
						  DialingMode,
						  LevelChanged,
						  Notes,
						  RuleId,
						  ExtRuleId,
						  NextCallBack,
						  IsImported,
						  HisCaseResult)
			  VALUES     (source.HisRespondent,
						  source.HisCallNumber,
						  source.HisInterviewer,
						  source.HisResult,
						  source.HisCallDate,
						  source.HisTimeSlot,
						  source.HisCallDuration,
						  source.HisDataType,
						  source.HisStartQuestion,
						  source.HisEndQuestion,
						  source.HisMonitoring,
						  source.HisDialerLine,
						  source.HisWait,
						  source.HisPause,
						  source.HisFileReference,
						  source.HisPreviousCallDate,
						  source.HisLifeState,
						  source.projectId,
						  source.collectMode, 
						  source.HisPhone,
						  IsNull(source.DialingMode,0),
						  source.LevelChanged,
						  source.Notes,
						  source.RuleId,
						  source.ExtRuleId,
						  source.NextCallBack,
						  source.IsImported,
						  source.HisCaseResult);
		'
	END
ELSE
	BEGIN
		--We are still using UPDATE for SQL2005 and below
		EXEC dbo.sp_executesql @statement = N'
		CREATE PROCEDURE [dbo].[Sp_updaterespondenthistory]
			@ProjectId           INT,
			@CollectMode         INT,
			@HisRespondent       VARCHAR(10),
			@HisCallNumber       INT,
			@HisInterviewer      VARCHAR(10),
			@HisResult           VARCHAR(2),
			@HisCallDate         DATETIME,
			@HisTimeSlot         INT,
			@HisCallDuration     INT,
			@HisDataType         INT,
			@HisStartQuestion    VARCHAR(10),
			@HisEndQuestion      VARCHAR(10),
			@HisMonitoring       BIT,
			@HisDialerLine       INT,
			@HisWait             INT,
			@HisPause            INT,
			@HisFileReference    VARCHAR(120),
			@HisPreviousCallDate DATETIME,
			@HisLifeState        VARCHAR(2),
			@HisPhone            VARCHAR(20) = NULL,
			@DialingMode         INT = NULL, -- Null => Do not change
			@LevelChanged        BIT = 0,
			@Notes               NVARCHAR(MAX) = NULL,
			@RuleId              INT = NULL,
			@ExtRuleId           INT = NULL,
			@NextCBKDate         DATETIME = NULL,
			@IsImported          BIT = 0,
			@HisCaseResult		 VARCHAR(2) = NULL
		AS
		  UPDATE historic
		  SET    hisrespondent = @HisRespondent,
				 hiscallnumber = @HisCallNumber,
				 hisinterviewer = @HisInterviewer,
				 hisresult = @HisResult,
				 hiscalldate = @HisCallDate,
				 histimeslot = @HisTimeSlot,
				 hiscallduration = @HisCallDuration,
				 hisdatatype = @HisDataType,
				 hisstartquestion = @HisStartQuestion,
				 hisendquestion = @HisEndQuestion,
				 hismonitoring = @HisMonitoring,
				 hisdialerline = @HisDialerLine,
				 hiswait = @HisWait,
				 hispause = @HisPause,
				 hisfilereference = @HisFileReference,
				 hispreviouscalldate = @HisPreviousCallDate,
				 hislifestate = @HisLifeState,
				 projectid = @projectId,
				 collectmode = @collectMode,
				 HisPhone = @HisPhone,
				 DialingMode = IsNull(@DialingMode,DialingMode),
				 LevelChanged = @LevelChanged,
				 Notes = @Notes,
				 RuleId = @RuleId,
				 ExtRuleId = @ExtRuleId,
				 NextCallBack = @NextCBKDate,
				 IsImported = @IsImported,
				 HisCaseResult = @HisCaseResult
		  WHERE  hisrespondent = @HisRespondent
				 AND hiscallnumber = @HisCallNumber
		  IF @@ROWCOUNT = 0
			BEGIN
			  INSERT INTO historic
						 (hisrespondent,
						  hiscallnumber,
						  hisinterviewer,
						  hisresult,
						  hiscalldate,
						  histimeslot,
						  hiscallduration,
						  hisdatatype,
						  hisstartquestion,
						  hisendquestion,
						  hismonitoring,
						  hisdialerline,
						  hiswait,
						  hispause,
						  hisfilereference,
						  hispreviouscalldate,
						  hislifestate,
						  projectid,
						  collectmode,
						  HisPhone,
						  DialingMode,
						  LevelChanged,
						  Notes,
						  RuleId,
						  ExtRuleId,
						  NextCallBack,
						  IsImported,
						  HisCaseResult)
			  VALUES     (@HisRespondent,
						  @HisCallNumber,
						  @HisInterviewer,
						  @HisResult,
						  @HisCallDate,
						  @HisTimeSlot,
						  @HisCallDuration,
						  @HisDataType,
						  @HisStartQuestion,
						  @HisEndQuestion,
						  @HisMonitoring,
						  @HisDialerLine,
						  @HisWait,
						  @HisPause,
						  @HisFileReference,
						  @HisPreviousCallDate,
						  @HisLifeState,
						  @projectId,
						  @collectMode, 
						  @HisPhone,
						  IsNull(@DialingMode,0),
						  @LevelChanged,
						  @Notes,
						  @RuleId,
						  @ExtRuleId,
						  @NextCBKDate,
						  @IsImported,
						  @HisCaseResult)
			END
		'
	END

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VX_sp_GetHistoric]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[VX_sp_GetHistoric]
GO

CREATE PROCEDURE [dbo].[VX_sp_GetHistoric]
 @nvcHisRespondent nvarchar(10)
AS
BEGIN
	SELECT HisRespondent, HisCallNumber, HisInterviewer, HisResult, HisCallDate, HisCallDate as [HisCallDateTime], HisTimeSlot, HisCallDuration, HisDataType, HisStartQuestion, 
		   HisEndQuestion, HisMonitoring, HisDialerLine, HisWait, HisPause, HisFileReference, HisPreviousCallDate, HisLifeState, projectId, collectMode, DialingMode, HisCaseResult
	FROM Historic
	WHERE HisRespondent = @nvcHisRespondent
END
GO

